/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于获取插件界面
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.28
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_get_plug_list */
/* exported mc_use_plug */


/* global $ */
/* global mc_sdk_param */
/* global mc_get_top_fun */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取插件列表
 * 参数:
 *     @param { Promise<Function> } fun_callback 回调函数
 * 返回：
 *    @return { Promise<Array> }
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.28
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_get_plug_list(fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("ADDON_LIST");

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var str_error_date;
        var arr = [];
        var arr_each = [];

        for (var idx = 0; idx < obj_res.get_param_cnt(); idx++) {
            var str_param_name = obj_res.get_param_name(idx);

            if ("ERROR_CODE" === str_param_name) {
                str_error_date = obj_res.get_param_value(str_param_name);
            } else {
                // var data = obj_res.get_attr_val(str_param_name, "BRIGHT_STEP");

                arr_each.push(str_param_name);
                try {
                    if ("null" === obj_res.get_param_value(str_param_name) || !obj_res.get_param_value(str_param_name)) {
                        arr_each.push("");
                    } else {
                        arr_each.push(obj_res.get_param_value(str_param_name));
                    }
                } catch (error) {
                    arr_each.push("");
                }

                arr_each.push(obj_res.get_attr_val(str_param_name, "REMOTE_EXEC"));
                arr.push(arr_each);
                arr_each = [];
            }
        }
        fun_callback(arr, str_error_date);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    运行插件
 * 参数:
 *     @param { Promise<Function> } fun_callback 回调函数
 *     @param { Promise<String> } str_plug_name 插件名称
 * 返回：
 *    @return { Promise<Array> }
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.29
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_use_plug(str_plug_name, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("SET_PARAM");
    obj_req.set_func("ADDON_EXEC");
    obj_req.set_param_value(str_plug_name, "");

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var str_error_date = obj_res.get_param_value("ERROR_CODE");


        fun_callback(str_error_date);
    });
}

var g_b_clk_v = false;
var g_b_clk_c = false;

document.onkeydown = function (e) {
    var evt = e || window.event;

    if (86 === evt.keyCode) {
        g_b_clk_v = true;
    } else if (67 === evt.keyCode) {
        g_b_clk_c = true;
    } else if (
        83 === evt.keyCode &&
        g_b_clk_v &&
        g_b_clk_c
    ) {
        // 进入信息控制对话框
        var obj_popout = {
            url: "/pages/hw_data/hw_data.html",
            icon: "icon-align-left",
            title: "MC_LANG_HW_DATA_TITLE",
            area: ["90%", "90%"],
            set_shade: 0,
            skin: "layui-anim layui-anim-rl layui-layer-adminRight level_st"

        };
        // 打开弹层页面

        parent.G_OBJ_ROUTER_PAGE.set_popup_layer_msg(obj_popout);
        parent.G_OBJ_ROUTER_PAGE.open_popup_layer();
        g_b_clk_v = false;
        g_b_clk_c = false;
    } else {
        g_b_clk_v = false;
        g_b_clk_c = false;
    }
};
